﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Utilities;
using System.Data;
using System.Runtime.Serialization;
using System.Xml.Serialization;

namespace AZVIC.Ei8htPOS.Entities
{
    [Serializable]
    [DataContract]
    public class Products : BusinessBaseClass
    {
        public Products()
        {
            ProductsXCategoryList = new List<ProductsXCategory>();
            ProductMeasurementList = new List<ProductsXMeasurements>();
        }

        public Products(IDataReader myDataRecord)
        {
            ShareInventoryID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ShareInventoryID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("ShareInventoryID"));
            UniqueID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ProductsID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("ProductsID"));
            ProductCategoryID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ProductCategoryID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("ProductCategoryID"));
            //ProductSubCategoryID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ProductSubCategoryID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("ProductSubCategoryID"));
            ProductBrandID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ProductBrandID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("ProductBrandID"));
            ProductColorID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ProductColorID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("ProductColorID"));
            ProductMeasurementID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ProductMeasurementID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("ProductMeasurementID"));
            ProductName = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ProductName")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("ProductName"));
            ProductDescriptions = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ProductDescriptions")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("ProductDescriptions"));
            ProductDescriptionsForQuote = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ProductDescriptionsForQuote")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("ProductDescriptionsForQuote"));
            ProductCode = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ProductCode")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("ProductCode"));
            AdditionalInfo = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("AdditionalInfo")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("AdditionalInfo"));
            ProductHeight = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ProductHeight")) ? 0 : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("ProductHeight"));
            ProductDepth = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ProductDepth")) ? 0 : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("ProductDepth"));
            ProductWidth = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ProductWidth")) ? 0 : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("ProductWidth"));
            ProductWeight = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ProductWeight")) ? 0 : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("ProductWeight"));
            UnitPrice = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("UnitPrice")) ? 0 : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("UnitPrice"));
            ShowProductPrice = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ShowProductPrice")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("ShowProductPrice"));
            Image1 = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Image1")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("Image1"));
            Image2 = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Image2")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("Image2"));
            Image3 = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Image3")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("Image3"));
            Image4 = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Image4")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("Image4"));
            Image5 = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Image5")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("Image5"));
            URLFor3DView = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("URLFor3DView")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("URLFor3DView"));
            DesignerInfo = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("DesignerInfo")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("DesignerInfo"));
            EarliestAvailableDays = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("EarliestAvailableDays")) ? 0 : myDataRecord.GetInt32(myDataRecord.GetOrdinal("EarliestAvailableDays"));
            ActualStock = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ActualStock")) ? 0 : myDataRecord.GetInt32(myDataRecord.GetOrdinal("ActualStock"));
            ReserveStock = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ReserveStock")) ? 0 : myDataRecord.GetInt32(myDataRecord.GetOrdinal("ReserveStock"));
            LowStockIndication = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("LowStockIndication")) ? 0 : myDataRecord.GetInt32(myDataRecord.GetOrdinal("LowStockIndication"));
            PromoSalesQty = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("PromoSalesQty")) ? 0 : myDataRecord.GetInt32(myDataRecord.GetOrdinal("PromoSalesQty"));
            IsNew = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsNew")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsNew"));
            IsBestSales = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsBestSales")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsBestSales"));
            IsSales = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsSales")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsSales"));
            IsMiscellaneous = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsMiscellaneous")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsMiscellaneous"));
            ProductWarrenty = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ProductWarrenty")) ? 0 : myDataRecord.GetInt32(myDataRecord.GetOrdinal("ProductWarrenty"));
            SequenceNo = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("SequenceNo")) ? 0 : myDataRecord.GetInt32(myDataRecord.GetOrdinal("SequenceNo"));
            AccessoriesType = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("AccessoriesType")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("AccessoriesType"));
            IsARProduct = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsARProduct")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsARProduct"));
            UserAccountID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CreatedBy")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("CreatedBy"));
            CreatedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CreatedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("CreatedDate"));
            ModifiedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ModifiedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("ModifiedDate"));
            IsActive = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsActive")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsActive"));
            HappyHourPrice = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("HappyHourPrice")) ? 0 : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("HappyHourPrice"));
            //IsDeleted = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsDeleted")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsDeleted"));

        }

        [DataObjectField(true, false, false)]
        [DataMember]
        public override Guid UniqueID { get; set; }
        [DataMember]
        public Guid ProductCategoryID { get; set; }

        [DataMember]
        public Guid ShareInventoryID { get; set; }

        [DataMember]
        public decimal HappyHourPrice { get; set; }

        [DataMember]
        public Guid ProductBrandID { get; set; }

        [DataMember]
        public Guid ProductColorID { get; set; }

        [DataMember]
        public Guid ProductMeasurementID { get; set; }

        [DataMember]
        public string ProductName { get; set; }

        [DataMember]
        public string ProductDescriptions { get; set; }

        [DataMember]
        public string ProductDescriptionsForQuote { get; set; }

        [DataMember]
        public string ProductCode { get; set; }

        [DataMember]
        public string AdditionalInfo { get; set; }

        [DataMember]
        public decimal ProductHeight { get; set; }

        [DataMember]
        public decimal ProductDepth { get; set; }

        [DataMember]
        public decimal ProductWidth { get; set; }

        [DataMember]
        public decimal ProductWeight { get; set; }

        [DataMember]
        public decimal UnitPrice { get; set; }

        [DataMember]
        public bool ShowProductPrice { get; set; }

        [DataMember]
        public string Image1 { get; set; }
        [DataMember]
        public string Image2 { get; set; }
        [DataMember]
        public string Image3 { get; set; }
        [DataMember]
        public string Image4 { get; set; }
        [DataMember]
        public string Image5 { get; set; }
        [DataMember]
        public string URLFor3DView { get; set; }
        [DataMember]
        public string DesignerInfo { get; set; }
        [DataMember]
        public int EarliestAvailableDays { get; set; }
        [DataMember]
        public int ActualStock { get; set; }
        [DataMember]
        public int ReserveStock { get; set; }
        [DataMember]
        public int LowStockIndication { get; set; }
        [DataMember]
        public int PromoSalesQty { get; set; }
        [DataMember]
        public bool IsNew { get; set; }
        [DataMember]
        public bool IsBestSales { get; set; }
        [DataMember]
        public bool IsSales { get; set; }
        [DataMember]
        public bool IsMiscellaneous { get; set; }
        [DataMember]
        public int ProductWarrenty { get; set; }
        [DataMember]
        public string AccessoriesType { get; set; }
        [DataMember]
        public bool IsARProduct { get; set; }
        [DataMember]
        public int SequenceNo { get; set; }
        [DataMember]
        public Guid UserAccountID { get; set; }
        [DataMember]
        public override DateTime CreatedDate { get; set; }
        [DataMember]
        public override DateTime ModifiedDate { get; set; }
        [DataMember]
        [XmlIgnore]
        public override GlobalConfigurations.Mode Mode { get; set; }
        [DataMember]
        public override bool IsActive { get; set; }
        [DataMember]
        public List<ProductsXCategory> ProductsXCategoryList;

        [DataMember]
        public List<ProductsXMeasurements> ProductMeasurementList;
    }
}
